/** @odoo-module **/

import { CANCEL_GLOBAL_CLICK, StreamPostKanbanRecord } from '@social/js/stream_post_kanban_record';
import { StreamPostCommentsYoutube } from './stream_post_comments';

import { patch } from '@web/core/utils/patch';

patch(StreamPostKanbanRecord.prototype, 'social_youtube.StreamPostKanbanRecord', {

    _onYoutubeCommentsClick() {
        const postId = this.record.id.raw_value;
        this.rpc('/social_youtube/get_comments', {
            stream_post_id: postId,
            comments_count: this.commentsCount,
        }).then((result) => {
            this.dialog.add(StreamPostCommentsYoutube, {
                title: this.env._t('YouTube Comments'),
                accountId: this.record.account_id.raw_value,
                originalPost: this.record,
                postId: postId,
                comments: result.comments,
                nextPageToken: result.nextPageToken,
            });
        });
    },

    onGlobalClick(ev) {
        if (ev.target.closest('.o_social_youtube_thumbnail')) {
            ev.preventDefault();
        } else if (ev.target.closest(CANCEL_GLOBAL_CLICK)) {
            return;
        }
        this.rootRef.el.querySelector('.o_social_comments').click();
    }

});
