# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo import fields, models, _
from odoo.exceptions import UserError


class MrpProductionWorkcenterLine(models.Model):
    _inherit = "mrp.workorder"


    def button_quality_alert(self):
        self.ensure_one()
        action = self.env["ir.actions.actions"]._for_xml_id("quality_control.quality_alert_action_check")
        action['target'] = 'new'
        action['views'] = [(False, 'form')]
        action['context'] = {
            'default_company_id': self.company_id.id,
            'default_product_id': self.product_id.id,
            'default_product_tmpl_id': self.product_id.product_tmpl_id.id,
            'default_workorder_id': self.id,
            'default_production_id': self.production_id.id,
            'default_workcenter_id': self.workcenter_id.id,
            'discard_on_footer_button': True,
        }
        return action

    def button_finish(self):
        """ When using the Done button of the simplified view, validate directly some types of quality checks
        """
        for check in self.check_ids:
            if check.quality_state in ['pass', 'fail']:
                continue
            if check.test_type in ['register_consumed_materials', 'register_byproducts', 'instructions']:
                check.quality_state = 'pass'
            else:
                raise UserError(_("You first need to complete the Quality Check using the Tablet View before marking the Operation as Done."))
        return super().button_finish()
