# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo import fields, models


class MrpBom(models.Model):
    _inherit = 'mrp.bom'

    schedule_count = fields.Integer('Schedules', compute='_compute_schedule_count')

    def _compute_schedule_count(self):
        domain = [
            '|',
                ('product_id.bom_line_ids.bom_id', 'in', self.ids),
                '|',
                    ('product_id', 'in', self.product_id.ids),
                    ('product_id.product_tmpl_id', 'in', self.product_tmpl_id.ids),
        ]
        grouped_data = self.env['mrp.production.schedule'].read_group(
            domain, ['product_id'], ['product_id'])
        product_schedule_counts = {}
        for data in grouped_data:
            product_schedule_counts[data['product_id'][0]] = data['product_id_count']
        for bom in self:
            schedule_count = 0
            if bom.product_id:
                ids = bom.product_id.ids
            else:
                ids = bom.product_tmpl_id.product_variant_ids.ids
            for product_id in bom.bom_line_ids.product_id.ids + ids:
                schedule_count += product_schedule_counts.get(product_id, 0)
            bom.schedule_count = schedule_count
