﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="Search.aspx.vb" Inherits="Indexedsearching.Search" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title>Document Search</title>

    <style>
        body {
            font-family: "Segoe UI", Arial, sans-serif;
            background-color: #f4f6f9;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 90%;
            max-width: 1100px;
            margin: 30px auto;
        }

        .header {
            background-color: #2c3e50;
            color: white;
            padding: 16px 20px;
            border-radius: 6px 6px 0 0;
            font-size: 20px;
            font-weight: 600;
        }

        .card {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 0 0 6px 6px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .index-section {
            background-color: #fff3cd;
            border: 1px solid #ffc107;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .btn-index {
            background-color: #ffc107;
            color: #333;
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            font-size: 14px;
            cursor: pointer;
            margin-right: 10px;
        }

        .btn-index:hover {
            background-color: #e0a800;
        }

        .status-message {
            display: inline-block;
            padding: 8px 12px;
            border-radius: 4px;
            margin-top: 10px;
        }

        .status-success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .status-error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .status-warning {
            background-color: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }

        .form-row {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .form-row label {
            width: 180px;
            font-weight: 600;
            color: #333;
        }

        .form-row input {
            flex: 1;
            padding: 8px 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
        }

        .actions {
            margin-top: 20px;
            text-align: right;
        }

        .btn-search {
            background-color: #0078d7;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            font-size: 14px;
            cursor: pointer;
        }

        .btn-search:hover {
            background-color: #005fa3;
        }

        .results {
            margin-top: 30px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid th {
            background-color: #f0f2f5;
            font-weight: 600;
            padding: 10px;
            border-bottom: 2px solid #ddd;
            text-align: left;
        }

        .grid td {
            padding: 10px;
            border-bottom: 1px solid #eee;
            vertical-align: top;
        }

        .grid tr:hover {
            background-color: #fafafa;
        }

        .view-btn {
            background-color: #28a745;
            color: white;
            padding: 6px 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        .view-btn:hover {
            background-color: #1e7e34;
        }
    </style>
</head>

<body>
<form id="form1" runat="server">

<div class="container">

    <div class="header">
        Document Search
    </div>

    <div class="card">

        <div class="index-section">
            <strong>Index Management:</strong><br />
            <asp:Button ID="btnBuildIndex" runat="server" Text="Build/Rebuild Index" 
                        CssClass="btn-index" OnClick="btnBuildIndex_Click" />
            <small>Source: <strong><asp:Label ID="lblSourcePath" runat="server"></asp:Label></strong></small>
            <br />
            <asp:Label ID="lblIndexStatus" runat="server"></asp:Label>
        </div>

        <div class="form-row">
            <label>Must contain</label>
            <asp:TextBox ID="txtMust" runat="server" />
        </div>

        <div class="form-row">
            <label>May contain</label>
            <asp:TextBox ID="txtOr" runat="server" />
        </div>

        <div class="form-row">
            <label>Must NOT contain</label>
            <asp:TextBox ID="txtNot" runat="server" />
        </div>

        <div class="actions">
            <asp:Button ID="btnSearch"
                        runat="server"
                        Text="Search"
                        CssClass="btn-search"
                        OnClick="btnSearch_Click" />
        </div>

    </div>

    <div class="results">
    <asp:GridView ID="gvResults"
                  runat="server"
                  CssClass="grid"
                  AutoGenerateColumns="False"
                  OnRowCommand="gvResults_RowCommand">
        <Columns>
            <asp:BoundField DataField="filename" HeaderText="Filename" />
            <asp:BoundField DataField="line" HeaderText="Snippet" />
            <asp:TemplateField HeaderText="Action">
                <ItemTemplate>
                    <asp:Button runat="server" 
                                Text="View TIFF" 
                                CommandName="ViewFile" 
                                CommandArgument='<%# Eval("path") %>'
                                CssClass="view-btn" />
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
</div>

</div>

</form>
</body>
</html>