﻿Imports System
Imports System.Web
Imports System.IO
Imports System.Drawing
Imports System.Drawing.Imaging


Public Class ImageHandler
    Implements IHttpHandler

    Public Sub ProcessRequest(ByVal context As HttpContext) Implements IHttpHandler.ProcessRequest
        Dim fileParam = context.Request.QueryString("file")
        Dim pageParam = context.Request.QueryString("page")

        If String.IsNullOrEmpty(fileParam) Then
            context.Response.StatusCode = 400
            context.Response.Write("File required")
            Return
        End If

        Dim filePath = context.Server.UrlDecode(fileParam)
        Dim pageIndex As Integer = 0
        Integer.TryParse(pageParam, pageIndex)

        If Not File.Exists(filePath) Then
            context.Response.StatusCode = 404
            context.Response.Write("File not found")
            Return
        End If

        ' Security: restrict to allowed root
        Dim allowedRoot = LuceneSearch.ALLOWED_ROOT
        If Not filePath.StartsWith(allowedRoot, StringComparison.OrdinalIgnoreCase) Then
            context.Response.StatusCode = 403
            context.Response.Write("Access denied")
            Return
        End If

        Try
            Using img As Image = Image.FromFile(filePath)
                Dim fd = New FrameDimension(img.FrameDimensionsList(0))
                Dim frameCount = img.GetFrameCount(fd)

                If pageIndex < 0 Then pageIndex = 0
                If pageIndex >= frameCount Then pageIndex = frameCount - 1

                img.SelectActiveFrame(fd, pageIndex)

                Using ms As New MemoryStream()
                    img.Save(ms, ImageFormat.Jpeg)
                    ms.Position = 0
                    context.Response.ContentType = "image/jpeg"
                    context.Response.OutputStream.Write(ms.ToArray(), 0, CInt(ms.Length))
                End Using
            End Using
        Catch ex As Exception
            context.Response.StatusCode = 500
            context.Response.Write("Error: " & ex.Message)
        End Try
    End Sub

    Public ReadOnly Property IsReusable() As Boolean Implements IHttpHandler.IsReusable
        Get
            Return False
        End Get
    End Property
End Class
